//	CDiskURL.h

#ifndef _H_CDiskURL
#define _H_CDiskURL

#include "CDisk.h"

class CDesktop;

class CDiskUrl : public CDisk {

	public:
	
	OSErr		IDiskUrl(
		CDesktop		*desktop, 
		DiskImageRec	*imageRec);

	virtual		void		Dispose(void);
	
	virtual	void			Dismount(void);

	virtual	char			*GetName(char *buf);
	virtual	char			*GetDescription(char *buf);

	virtual	ulong			GetVolumeSize(void);
	virtual ADFS_IconType	GetIconType(void);

	virtual	void			GetAccessBits(Gen_AccessBits *bits);
	virtual	void			SetAccessBits(Gen_AccessBits *bits);

			ulong			GetVolumeBytesUsed(void);
			ulong			GetVolumeMaxFileSize(ushort pro_fileTypeS);
			ulong			CalcBytesUsedByFile(ulong fileSize);

	virtual	Boolean			DoCommand(long command);
	
	virtual	DateTimeRec		*GetCreatedTime(DateTimeRec *dt);
	virtual	DateTimeRec		*GetModifiedTime(DateTimeRec *dt);
	virtual	void			SetCreatedTime(DateTimeRec *dt);
	virtual	void			SetModifiedTime(DateTimeRec *dt);

	virtual	void			SetName(char *buf);
	virtual	Boolean			SupportsForks(void);
	virtual	Boolean			IsLocked(void);
	
	virtual	DateTimeRec		*GetModifiedTimeRemote(DateTimeRec *dt);
	virtual	void			RemoteChanged(void);
	
	void			SetTwirled(Boolean twirledB);	
	Boolean			GetTwirled(void);

	virtual	void		Open(void);

	/****************************************************/
	
	Gen_Item		*i_itemP;
	
	private:
	typedef CDisk		_inherited;
};



#endif
